package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.OS2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * OS2DaoImpl generated by UDA, 28-feb-2017 16:03:07.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class OS2DaoImpl implements OS2Dao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT  t1.TEROS2_060 TEROS2060,t1.ANOOS2_060 ANOOS2060,t1.NUMOS2_060 NUMOS2060,t1.FECPRE_060 FECPRE060,t1.FECIER_060 FECIER060,t1.TERAPE_060 TERAPE060,t1.ANOAPE_060 ANOAPE060,t1.NUMAPE_060 NUMAPE060,t1.TIPDOC_060 TIPDOC060,t1.NUMDOC_060 NUMDOC060,t1.NOMEMP_060 NOMEMP060,t1.PRVEMP_060 PRVEMP060,t1.MUNEMP_060 MUNEMP060,t1.DIREMP_060 DIREMP060,t1.CPOEMP_060 CPOEMP060,t1.TLFEMP_060 TLFEMP060,t1.FAXEMP_060 FAXEMP060,t1.EMAEMP_060 EMAEMP060,t1.HTTPEMP_060 HTTPEMP060,t1.CNAEEMP_060 CNAEEMP060,t1.INDANX_060 INDANX060,t1.APDOANX_060 APDOANX060,t1.PRVCTR_060 PRVCTR060,t1.MUNCTR_060 MUNCTR060,t1.LOCCTR_060 LOCCTR060,t1.DIRCTR_060 DIRCTR060,t1.CPOCTR_060 CPOCTR060,t1.TRBTOT_060 TRBTOT060,t1.TIPMPR1_060 TIPMPR1060,t1.NOMMPR1_060 NOMMPR1060,t1.TIPMPR2_060 TIPMPR2060,t1.NOMMPR2_060 NOMMPR2060,t1.TOPSEG1_060 TOPSEG1060,t1.TOPSEG2_060 TOPSEG2060,t1.TOPHIG1_060 TOPHIG1060,t1.TOPHIG2_060 TOPHIG2060,t1.TOPERG1_060 TOPERG1060,t1.TOPERG2_060 TOPERG2060,t1.TOPVIG1_060 TOPVIG1060,t1.TOPVIG2_060 TOPVIG2060,t1.TIPRIE1_060 TIPRIE1060,t1.NOMRIE1_060 NOMRIE1060,t1.TIPRIE2_060 TIPRIE2060,t1.NOMRIE2_060 NOMRIE2060,t1.INDAUD_060 INDAUD060,t1.FECAUD_060 FECAUD060,t1.EMPAUD_060 EMPAUD060,t1.OBSERV_060 OBSERV060,t1.CODCTR_060 CODCTR060,t1.FECALT_060 FECALT060,t1.USUALT_060 USUALT060,t1.FECMOD_060 FECMOD060,t1.USUMOD_060 USUMOD060,t1.DMUNEMP_060 DMUNEMP060,t1.DESCEMP_060 DESCEMP060,t1.DESCCEN_060 DESCCEN060,t1.PAISEMP_060 PAISEMP060,t1.DOCCORRECTA_060 DOCCORRECTA060,t1.CODEMPAUD_060 CODEMPAUD060,t1.CODPREV1_060 CODPREV1060,t1.CODPREV2_060 CODPREV2060,t1.ESTADO_060 ESTADO060,t1.CNAEEMP93_060 CNAEEMP93060,t1.FORPRE_060 FORPRE060, t1.MIGRADO_060 MIGRADO060, t1.FOLDER_ID_060 FOLDERID060, t1.COD_DATOS_NOTIF_060 CODDATOSNOTIF060, "
			+ "t1.NUMDOCREPRESENTANTE_060 NUMDOCREPRESENTANTE060, t1.TLFREPRESENTANTE_060 TLFREPRESENTANTE060, t1.TIT_REPR_060 TITREPR060, t1.NOMREPRESENTANTE_060 NOMREPRESENTANTE060 ,t1.TIPDOCREPRESENTANTE_060 TIPDOCREPRESENTANTE060, t1.USUARIO_APE_060 USUARIOAPE060, t1.USUARIO_APORT_060 USUARIOAPORT060, t1.USUARIO_TRAM_060 USUARIOTRAM060 ,t1.FECREQ_060 FECREQ060, t1.FECSUB_060 FECSUB060 ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ANOOS2_060 ANOOS2060, t1.NUMOS2_060 NUMOS2060, t1.TEROS2_060 TEROS2060 ";

	private static final String QUERY_SELECT_DATOS_REGISTRO = "SELECT t1.ANOOS2_060 ANOOS2060, t1.NUMOS2_060 NUMOS2060, t1.TEROS2_060 TEROS2060, t1.DESEA_REG_060 DESEAREG060, t1.NUM_REGISTRO_060 NUMREGISTRO060, t1.FEC_REGISTRO_060 FECREGISTRO060";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<OS2> rwMap = new RowMapper<OS2>() {
		public OS2 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new OS2(resultSet.getString("TEROS2060"),
					resultSet.getString("ANOOS2060"),
					resultSet.getInt("NUMOS2060"),
					resultSet.getTimestamp("FECPRE060"),
					resultSet.getDate("FECIER060"),
					resultSet.getString("TERAPE060"),
					resultSet.getString("ANOAPE060"),
					resultSet.getInt("NUMAPE060"),
					resultSet.getString("TIPDOC060"),
					resultSet.getString("NUMDOC060"),
					resultSet.getString("NOMEMP060"),
					resultSet.getString("PRVEMP060"),
					resultSet.getString("MUNEMP060"),
					resultSet.getString("DIREMP060"),
					resultSet.getString("CPOEMP060"),
					resultSet.getString("TLFEMP060"),
					resultSet.getString("FAXEMP060"),
					resultSet.getString("EMAEMP060"),
					resultSet.getString("HTTPEMP060"),
					resultSet.getString("CNAEEMP060"),
					resultSet.getString("INDANX060"),
					resultSet.getString("APDOANX060"),
					resultSet.getString("PRVCTR060"),
					resultSet.getString("MUNCTR060"),
					resultSet.getString("LOCCTR060"),
					resultSet.getString("DIRCTR060"),
					resultSet.getString("CPOCTR060"),
					resultSet.getInt("TRBTOT060"),
					resultSet.getString("TIPMPR1060"),
					resultSet.getString("NOMMPR1060"),
					resultSet.getString("TIPMPR2060"),
					resultSet.getString("NOMMPR2060"),
					resultSet.getString("TOPSEG1060"),
					resultSet.getString("TOPSEG2060"),
					resultSet.getString("TOPHIG1060"),
					resultSet.getString("TOPHIG2060"),
					resultSet.getString("TOPERG1060"),
					resultSet.getString("TOPERG2060"),
					resultSet.getString("TOPVIG1060"),
					resultSet.getString("TOPVIG2060"),
					resultSet.getString("TIPRIE1060"),
					resultSet.getString("NOMRIE1060"),
					resultSet.getString("TIPRIE2060"),
					resultSet.getString("NOMRIE2060"),
					resultSet.getString("INDAUD060"),
					resultSet.getDate("FECAUD060"),
					resultSet.getString("EMPAUD060"),
					resultSet.getString("OBSERV060"),
					resultSet.getInt("CODCTR060"),
					resultSet.getDate("FECALT060"),
					resultSet.getString("USUALT060"),
					resultSet.getDate("FECMOD060"),
					resultSet.getString("USUMOD060"),
					resultSet.getString("DMUNEMP060"),
					resultSet.getString("DESCEMP060"),
					resultSet.getString("DESCCEN060"),
					resultSet.getString("PAISEMP060"),
					resultSet.getString("DOCCORRECTA060"),
					resultSet.getString("CODEMPAUD060"),
					resultSet.getString("CODPREV1060"),
					resultSet.getString("CODPREV2060"),
					resultSet.getString("ESTADO060"),
					resultSet.getString("CNAEEMP93060"),
					resultSet.getString("FORPRE060"),
					resultSet.getString("MIGRADO060"),
					resultSet.getString("FOLDERID060"),
					resultSet.getString("CODDATOSNOTIF060"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF060")),
					resultSet.getString("NUMDOCREPRESENTANTE060"),
					resultSet.getString("TLFREPRESENTANTE060"),
					resultSet.getString("TITREPR060"),
					resultSet.getString("NOMREPRESENTANTE060"),
					resultSet.getString("TIPDOCREPRESENTANTE060"),
					resultSet.getString("USUARIOAPE060"),
					resultSet.getString("USUARIOAPORT060"),
					resultSet.getString("USUARIOTRAM060"),
					resultSet.getDate("FECSUB060"),
					resultSet.getDate("FECREQ060"));

		}
	};

	private RowMapper<OS2> rwMapPK = new RowMapper<OS2>() {
		public OS2 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new OS2(resultSet.getString("TEROS2060"),
					resultSet.getString("ANOOS2060"),
					resultSet.getInt("NUMOS2060"));
		}
	};

	private RowMapper<OS2> rwMapDatosRegistro = new RowMapper<OS2>() {
		public OS2 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			OS2 os2 = new OS2(resultSet.getString("TEROS2060"),
					resultSet.getString("ANOOS2060"),
					resultSet.getInt("NUMOS2060"));

			os2.setDeseaRegistrar060(resultSet.getString("DESEAREG060"));
			os2.setNumReg060(resultSet.getString("NUMREGISTRO060"));
			os2.setFecReg060(resultSet.getDate("FECREGISTRO060"));

			return os2;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	public OS2 add(OS2 ab0460s00) {
		String query = "INSERT INTO AB0460S00 (TEROS2_060, ANOOS2_060, NUMOS2_060, FECPRE_060, FECIER_060, TERAPE_060, ANOAPE_060, NUMAPE_060, TIPDOC_060, NUMDOC_060, NOMEMP_060, PRVEMP_060, MUNEMP_060, DIREMP_060, CPOEMP_060, TLFEMP_060, FAXEMP_060, EMAEMP_060, HTTPEMP_060, CNAEEMP_060, INDANX_060, APDOANX_060, PRVCTR_060, MUNCTR_060, LOCCTR_060, DIRCTR_060, CPOCTR_060, TRBTOT_060, TIPMPR1_060, NOMMPR1_060, TIPMPR2_060, NOMMPR2_060, TOPSEG1_060, TOPSEG2_060, TOPHIG1_060, TOPHIG2_060, TOPERG1_060, TOPERG2_060, TOPVIG1_060, TOPVIG2_060, TIPRIE1_060, NOMRIE1_060, TIPRIE2_060, NOMRIE2_060, INDAUD_060, FECAUD_060, EMPAUD_060, OBSERV_060, CODCTR_060, FECALT_060, USUALT_060, FECMOD_060, USUMOD_060, DMUNEMP_060, DESCEMP_060, DESCCEN_060, PAISEMP_060, DOCCORRECTA_060, CODEMPAUD_060, CODPREV1_060, CODPREV2_060, ESTADO_060, CNAEEMP93_060, FORPRE_060, MIGRADO_060, FOLDER_ID_060, COD_DATOS_NOTIF_060,NUMDOCREPRESENTANTE_060,TLFREPRESENTANTE_060,TIT_REPR_060,NOMREPRESENTANTE_060,TIPDOCREPRESENTANTE_060) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ab0460s00.getTeros2060(),
				ab0460s00.getAnoos2060(), ab0460s00.getNumos2060(),
				ab0460s00.getFecpre060(), ab0460s00.getFecier060(),
				ab0460s00.getTerape060(), ab0460s00.getAnoape060(),
				ab0460s00.getNumape060(), ab0460s00.getTipdoc060(),
				ab0460s00.getNumdoc060(), ab0460s00.getNomemp060(),
				ab0460s00.getPrvemp060(), ab0460s00.getMunemp060(),
				ab0460s00.getDiremp060(), ab0460s00.getCpoemp060(),
				ab0460s00.getTlfemp060(), ab0460s00.getFaxemp060(),
				ab0460s00.getEmaemp060(), ab0460s00.getHttpemp060(),
				ab0460s00.getCnaeemp060(), ab0460s00.getIndanx060(),
				ab0460s00.getApdoanx060(), ab0460s00.getPrvctr060(),
				ab0460s00.getMunctr060(), ab0460s00.getLocctr060(),
				ab0460s00.getDirctr060(), ab0460s00.getCpoctr060(),
				ab0460s00.getTrbtot060(), ab0460s00.getTipmpr1060(),
				ab0460s00.getNommpr1060(), ab0460s00.getTipmpr2060(),
				ab0460s00.getNommpr2060(), ab0460s00.getTopseg1060(),
				ab0460s00.getTopseg2060(), ab0460s00.getTophig1060(),
				ab0460s00.getTophig2060(), ab0460s00.getToperg1060(),
				ab0460s00.getToperg2060(), ab0460s00.getTopvig1060(),
				ab0460s00.getTopvig2060(), ab0460s00.getTiprie1060(),
				ab0460s00.getNomrie1060(), ab0460s00.getTiprie2060(),
				ab0460s00.getNomrie2060(), ab0460s00.getIndaud060(),
				ab0460s00.getFecaud060(), ab0460s00.getEmpaud060(),
				ab0460s00.getObserv060(), ab0460s00.getCodctr060(),
				ab0460s00.getFecalt060(), ab0460s00.getUsualt060(),
				ab0460s00.getFecmod060(), ab0460s00.getUsumod060(),
				ab0460s00.getDmunemp060(), ab0460s00.getDescemp060(),
				ab0460s00.getDesccen060(), ab0460s00.getPaisemp060(),
				ab0460s00.getDoccorrecta060(), ab0460s00.getCodempaud060(),
				ab0460s00.getCodprev1060(), ab0460s00.getCodprev2060(),
				ab0460s00.getEstado060(), ab0460s00.getCnaeemp93060(),
				ab0460s00.getForpre060(), ab0460s00.getMigrado060(),
				ab0460s00.getFolderId060(), ab0460s00.getCoddatosnotif060(),
				ab0460s00.getNumdocrepresentante060(),
				ab0460s00.getTlfrepresentante060(), "T",
				ab0460s00.getNomrepresentante060(),
				ab0460s00.getTipdocrepresentante060());
		return ab0460s00;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	public OS2 update(OS2 ab0460s00) {
		String query = "UPDATE AB0460S00 SET FECPRE_060=?, FECIER_060=?, TERAPE_060=?, ANOAPE_060=?, NUMAPE_060=?, TIPDOC_060=?, NUMDOC_060=?, NOMEMP_060=?, PRVEMP_060=?, MUNEMP_060=?, DIREMP_060=?, CPOEMP_060=?, TLFEMP_060=?, FAXEMP_060=?, EMAEMP_060=?, HTTPEMP_060=?, CNAEEMP_060=?, INDANX_060=?, APDOANX_060=?, PRVCTR_060=?, MUNCTR_060=?, LOCCTR_060=?, DIRCTR_060=?, CPOCTR_060=?, TRBTOT_060=?, TIPMPR1_060=?, NOMMPR1_060=?, TIPMPR2_060=?, NOMMPR2_060=?, TOPSEG1_060=?, TOPSEG2_060=?, TOPHIG1_060=?, TOPHIG2_060=?, TOPERG1_060=?, TOPERG2_060=?, TOPVIG1_060=?, TOPVIG2_060=?, TIPRIE1_060=?, NOMRIE1_060=?, TIPRIE2_060=?, NOMRIE2_060=?, INDAUD_060=?, FECAUD_060=?, EMPAUD_060=?, OBSERV_060=?, CODCTR_060=?, FECALT_060=?, USUALT_060=?, FECMOD_060=?, USUMOD_060=?, DMUNEMP_060=?, DESCEMP_060=?, DESCCEN_060=?, PAISEMP_060=?, DOCCORRECTA_060=?, CODEMPAUD_060=?, CODPREV1_060=?, CODPREV2_060=?, ESTADO_060=?, CNAEEMP93_060=?, FORPRE_060=?, MIGRADO_060=?, FOLDER_ID_060=?, COD_DATOS_NOTIF_060=?, NUMDOCREPRESENTANTE_060=?,TLFREPRESENTANTE_060=?,TIT_REPR_060=?,NOMREPRESENTANTE_060=?,TIPDOCREPRESENTANTE_060=?, FECSUB_060=?, FECREQ_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=? ";
		this.jdbcTemplate.update(query, ab0460s00.getFecpre060(),
				ab0460s00.getFecier060(), ab0460s00.getTerape060(),
				ab0460s00.getAnoape060(), ab0460s00.getNumape060(),
				ab0460s00.getTipdoc060(), ab0460s00.getNumdoc060(),
				ab0460s00.getNomemp060(), ab0460s00.getPrvemp060(),
				ab0460s00.getMunemp060(), ab0460s00.getDiremp060(),
				ab0460s00.getCpoemp060(), ab0460s00.getTlfemp060(),
				ab0460s00.getFaxemp060(), ab0460s00.getEmaemp060(),
				ab0460s00.getHttpemp060(), ab0460s00.getCnaeemp060(),
				ab0460s00.getIndanx060(), ab0460s00.getApdoanx060(),
				ab0460s00.getPrvctr060(), ab0460s00.getMunctr060(),
				ab0460s00.getLocctr060(), ab0460s00.getDirctr060(),
				ab0460s00.getCpoctr060(), ab0460s00.getTrbtot060(),
				ab0460s00.getTipmpr1060(), ab0460s00.getNommpr1060(),
				ab0460s00.getTipmpr2060(), ab0460s00.getNommpr2060(),
				ab0460s00.getTopseg1060(), ab0460s00.getTopseg2060(),
				ab0460s00.getTophig1060(), ab0460s00.getTophig2060(),
				ab0460s00.getToperg1060(), ab0460s00.getToperg2060(),
				ab0460s00.getTopvig1060(), ab0460s00.getTopvig2060(),
				ab0460s00.getTiprie1060(), ab0460s00.getNomrie1060(),
				ab0460s00.getTiprie2060(), ab0460s00.getNomrie2060(),
				ab0460s00.getIndaud060(), ab0460s00.getFecaud060(),
				ab0460s00.getEmpaud060(), ab0460s00.getObserv060(),
				ab0460s00.getCodctr060(), ab0460s00.getFecalt060(),
				ab0460s00.getUsualt060(), ab0460s00.getFecmod060(),
				ab0460s00.getUsumod060(), ab0460s00.getDmunemp060(),
				ab0460s00.getDescemp060(), ab0460s00.getDesccen060(),
				ab0460s00.getPaisemp060(), ab0460s00.getDoccorrecta060(),
				ab0460s00.getCodempaud060(), ab0460s00.getCodprev1060(),
				ab0460s00.getCodprev2060(), ab0460s00.getEstado060(),
				ab0460s00.getCnaeemp93060(), ab0460s00.getForpre060(),
				ab0460s00.getMigrado060(), ab0460s00.getFolderId060(),
				ab0460s00.getCoddatosnotif060(),
				ab0460s00.getNumdocrepresentante060(),
				ab0460s00.getTlfrepresentante060(), ab0460s00.getTitRepr060(),
				ab0460s00.getNomrepresentante060(),
				ab0460s00.getTipdocrepresentante060(), ab0460s00.getFecsub060(),
				ab0460s00.getFecreq060(), ab0460s00.getTeros2060(),
				ab0460s00.getAnoos2060(), ab0460s00.getNumos2060());

		return ab0460s00;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 modificarDatosTabNotificacionOS2(OS2 os2) {
		String query = "UPDATE AB0460S00 SET COD_DATOS_NOTIF_060=?,NUMDOCREPRESENTANTE_060=?,TIPDOCREPRESENTANTE_060=?,NOMREPRESENTANTE_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query,
				os2.getDatosNotificacion().getCodDatosNotif066(),

				os2.getNumdocrepresentante060(),
				os2.getTipdocrepresentante060(), os2.getNomrepresentante060(),

				os2.getTeros2060(), os2.getAnoos2060(), os2.getNumos2060());
		return os2;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 modificarDatosTabEmpresaOS2(OS2 os2) {
		String query = "UPDATE AB0460S00 SET CODCTR_060=?, TIPDOC_060=?, NUMDOC_060=?, NOMEMP_060=?, CNAEEMP_060=?, INDANX_060=?, APDOANX_060=?, PAISEMP_060=?, PRVEMP_060=?, MUNEMP_060=?, DMUNEMP_060=?, DIREMP_060=?, CPOEMP_060=?, TLFEMP_060=?, FAXEMP_060=?, TRBTOT_060=?, HTTPEMP_060=?, EMAEMP_060=?, PRVCTR_060=?, MUNCTR_060=?, LOCCTR_060=?, CPOCTR_060=?, DIRCTR_060=?,TERAPE_060=? , ANOAPE_060=? , NUMAPE_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query, os2.getCodctr060(), os2.getTipdoc060(),
				os2.getNumdoc060(), os2.getNomemp060(), os2.getCnaeemp060(),
				os2.getIndanx060(), os2.getApdoanx060(), os2.getPaisemp060(),
				os2.getPrvemp060(), os2.getMunemp060(), os2.getDmunemp060(),
				os2.getDiremp060(), os2.getCpoemp060(), os2.getTlfemp060(),
				os2.getFaxemp060(), os2.getTrbtot060(), os2.getHttpemp060(),
				os2.getEmaemp060(), os2.getPrvctr060(), os2.getMunctr060(),
				os2.getLocctr060(), os2.getCpoctr060(), os2.getDirctr060(),
				os2.getTerape060(), os2.getAnoape060(), os2.getNumape060(),
				os2.getTeros2060(), os2.getAnoos2060(), os2.getNumos2060());
		return os2;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 modificarDatosTabModalidad(OS2 os2) {
		String query = "UPDATE AB0460S00 SET TIPMPR1_060=?, CODPREV1_060=?, NOMMPR1_060=?, TIPMPR2_060=?, CODPREV2_060=?, NOMMPR2_060=?, TOPSEG1_060=?, TOPSEG2_060=?, TOPHIG1_060=?, TOPHIG2_060=?, TOPERG1_060=?, TOPERG2_060=?, TOPVIG1_060=?, TOPVIG2_060=?, TIPRIE1_060=?, NOMRIE1_060=?, TIPRIE2_060=?, NOMRIE2_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query, os2.getTipmpr1060(),
				os2.getCodprev1060(), os2.getNommpr1060(), os2.getTipmpr2060(),
				os2.getCodprev2060(), os2.getNommpr2060(), os2.getTopseg1060(),
				os2.getTopseg2060(), os2.getTophig1060(), os2.getTophig2060(),
				os2.getToperg1060(), os2.getToperg2060(), os2.getTopvig1060(),
				os2.getTopvig2060(), os2.getTiprie1060(), os2.getNomrie1060(),
				os2.getTiprie2060(), os2.getNomrie2060(), os2.getTeros2060(),
				os2.getAnoos2060(), os2.getNumos2060());
		return os2;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 modificarDatosTabAuditoria(OS2 os2) {
		String query = "UPDATE AB0460S00 SET INDAUD_060=?, FECAUD_060=?, EMPAUD_060=?, CODEMPAUD_060=?, OBSERV_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query, os2.getIndaud060(), os2.getFecaud060(),
				os2.getEmpaud060(), os2.getCodempaud060(), os2.getObserv060(),
				os2.getTeros2060(), os2.getAnoos2060(), os2.getNumos2060());
		return os2;
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 modificarDatosTabEstadoOS2(OS2 os2) {
		String query = "UPDATE AB0460S00 SET DOCCORRECTA_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query,
				os2.getDoccorrecta060() != null ? os2.getDoccorrecta060()
						: Constantes.VALUE_NO,
				os2.getTeros2060(), os2.getAnoos2060(), os2.getNumos2060());
		return os2;
	}

	/**
	 * Finds a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	@Transactional(readOnly = true)
	public OS2 find(OS2 ab0460s00) {
		String query = QUERY_SELECT
				+ " FROM AB0460S00 t1  WHERE t1.TEROS2_060 = ?   AND t1.ANOOS2_060 = ?   AND t1.NUMOS2_060 = ?  ";

		List<OS2> ab0460s00List = this.jdbcTemplate.query(query, this.rwMap,
				ab0460s00.getTeros2060(), ab0460s00.getAnoos2060(),
				ab0460s00.getNumos2060());
		return (OS2) DataAccessUtils.uniqueResult(ab0460s00List);
	}

	/**
	 * Removes a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 */
	public void remove(OS2 ab0460s00) {
		String query = "DELETE FROM AB0460S00 WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query, ab0460s00.getTeros2060(),
				ab0460s00.getAnoos2060(), ab0460s00.getNumos2060());
	}

	/**
	 * Finds a list of rows in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<OS2> findAll(OS2 ab0460s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0460s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<OS2>) this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
	}

	/**
	 * Finds rows in the Ab0460s00 table using like.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<OS2> findAllLike(OS2 ab0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0460s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<OS2>) this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Long
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(OS2 ab0460s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0460s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0460s00 table using like.
	 * 
	 * ab0460s00 Ab0460s00 startsWith Boolean Long
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(OS2 ab0460s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0460S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0460s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0460s00 selected for rup_table.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0460s00>>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<OS2>> reorderSelection(OS2 ab0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		// FROM
		query.append(" FROM AB0460S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0460s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, OS2.class, filterParamList,
				"TEROS2_060,ANOOS2_060,NUMOS2_060");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<OS2>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0460s00 searchParams Ab0460s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0460s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<OS2>> search(OS2 filterParams, OS2 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		// FROM
		query.append(" FROM AB0460S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, OS2.class, filterParamList, searchSQL,
				searchParamList, from_alias,
				"TEROS2_060,ANOOS2_060,NUMOS2_060");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<OS2>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0460s00 entity.
	 * 
	 * ab0460s00 Ab0460s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(OS2 ab0460s00) {

		StringBuilder where = new StringBuilder(OS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0460s00 != null && ab0460s00.getTeros2060() != null) {
			where.append(" AND t1.TEROS2_060 = ?");
			params.add(ab0460s00.getTeros2060());
		}
		if (ab0460s00 != null && ab0460s00.getAnoos2060() != null) {
			where.append(" AND t1.ANOOS2_060 = ?");
			params.add(ab0460s00.getAnoos2060());
		}
		if (ab0460s00 != null && ab0460s00.getNumos2060() != null) {
			where.append(" AND t1.NUMOS2_060 = ?");
			params.add(ab0460s00.getNumos2060());
		}
		if (ab0460s00 != null && ab0460s00.getFecpre060() != null) {
			where.append(" AND t1.FECPRE_060 = ?");
			params.add(ab0460s00.getFecpre060());
		}
		if (ab0460s00 != null && ab0460s00.getFecier060() != null) {
			where.append(" AND t1.FECIER_060 = ?");
			params.add(ab0460s00.getFecier060());
		}
		if (ab0460s00 != null && ab0460s00.getTerape060() != null) {
			where.append(" AND t1.TERAPE_060 = ?");
			params.add(ab0460s00.getTerape060());
		}
		if (ab0460s00 != null && ab0460s00.getAnoape060() != null) {
			where.append(" AND t1.ANOAPE_060 = ?");
			params.add(ab0460s00.getAnoape060());
		}
		if (ab0460s00 != null && ab0460s00.getNumape060() != null) {
			where.append(" AND t1.NUMAPE_060 = ?");
			params.add(ab0460s00.getNumape060());
		}
		if (ab0460s00 != null && ab0460s00.getTipdoc060() != null) {
			where.append(" AND t1.TIPDOC_060 = ?");
			params.add(ab0460s00.getTipdoc060());
		}
		if (ab0460s00 != null && ab0460s00.getNumdoc060() != null) {
			where.append(" AND t1.NUMDOC_060 = ?");
			params.add(ab0460s00.getNumdoc060());
		}
		if (ab0460s00 != null && ab0460s00.getNomemp060() != null) {
			where.append(" AND t1.NOMEMP_060 = ?");
			params.add(ab0460s00.getNomemp060());
		}
		if (ab0460s00 != null && ab0460s00.getPrvemp060() != null) {
			where.append(" AND t1.PRVEMP_060 = ?");
			params.add(ab0460s00.getPrvemp060());
		}
		if (ab0460s00 != null && ab0460s00.getMunemp060() != null) {
			where.append(" AND t1.MUNEMP_060 = ?");
			params.add(ab0460s00.getMunemp060());
		}
		if (ab0460s00 != null && ab0460s00.getDiremp060() != null) {
			where.append(" AND t1.DIREMP_060 = ?");
			params.add(ab0460s00.getDiremp060());
		}
		if (ab0460s00 != null && ab0460s00.getCpoemp060() != null) {
			where.append(" AND t1.CPOEMP_060 = ?");
			params.add(ab0460s00.getCpoemp060());
		}
		if (ab0460s00 != null && ab0460s00.getTlfemp060() != null) {
			where.append(" AND t1.TLFEMP_060 = ?");
			params.add(ab0460s00.getTlfemp060());
		}
		if (ab0460s00 != null && ab0460s00.getFaxemp060() != null) {
			where.append(" AND t1.FAXEMP_060 = ?");
			params.add(ab0460s00.getFaxemp060());
		}
		if (ab0460s00 != null && ab0460s00.getEmaemp060() != null) {
			where.append(" AND t1.EMAEMP_060 = ?");
			params.add(ab0460s00.getEmaemp060());
		}
		if (ab0460s00 != null && ab0460s00.getHttpemp060() != null) {
			where.append(" AND t1.HTTPEMP_060 = ?");
			params.add(ab0460s00.getHttpemp060());
		}
		if (ab0460s00 != null && ab0460s00.getCnaeemp060() != null) {
			where.append(" AND t1.CNAEEMP_060 = ?");
			params.add(ab0460s00.getCnaeemp060());
		}
		if (ab0460s00 != null && ab0460s00.getIndanx060() != null) {
			where.append(" AND t1.INDANX_060 = ?");
			params.add(ab0460s00.getIndanx060());
		}
		if (ab0460s00 != null && ab0460s00.getApdoanx060() != null) {
			where.append(" AND t1.APDOANX_060 = ?");
			params.add(ab0460s00.getApdoanx060());
		}
		if (ab0460s00 != null && ab0460s00.getPrvctr060() != null) {
			where.append(" AND t1.PRVCTR_060 = ?");
			params.add(ab0460s00.getPrvctr060());
		}
		if (ab0460s00 != null && ab0460s00.getMunctr060() != null) {
			where.append(" AND t1.MUNCTR_060 = ?");
			params.add(ab0460s00.getMunctr060());
		}
		if (ab0460s00 != null && ab0460s00.getLocctr060() != null) {
			where.append(" AND t1.LOCCTR_060 = ?");
			params.add(ab0460s00.getLocctr060());
		}
		if (ab0460s00 != null && ab0460s00.getDirctr060() != null) {
			where.append(" AND t1.DIRCTR_060 = ?");
			params.add(ab0460s00.getDirctr060());
		}
		if (ab0460s00 != null && ab0460s00.getCpoctr060() != null) {
			where.append(" AND t1.CPOCTR_060 = ?");
			params.add(ab0460s00.getCpoctr060());
		}
		if (ab0460s00 != null && ab0460s00.getTrbtot060() != null) {
			where.append(" AND t1.TRBTOT_060 = ?");
			params.add(ab0460s00.getTrbtot060());
		}
		if (ab0460s00 != null && ab0460s00.getTipmpr1060() != null) {
			where.append(" AND t1.TIPMPR1_060 = ?");
			params.add(ab0460s00.getTipmpr1060());
		}
		if (ab0460s00 != null && ab0460s00.getNommpr1060() != null) {
			where.append(" AND t1.NOMMPR1_060 = ?");
			params.add(ab0460s00.getNommpr1060());
		}
		if (ab0460s00 != null && ab0460s00.getTipmpr2060() != null) {
			where.append(" AND t1.TIPMPR2_060 = ?");
			params.add(ab0460s00.getTipmpr2060());
		}
		if (ab0460s00 != null && ab0460s00.getNommpr2060() != null) {
			where.append(" AND t1.NOMMPR2_060 = ?");
			params.add(ab0460s00.getNommpr2060());
		}
		if (ab0460s00 != null && ab0460s00.getTopseg1060() != null) {
			where.append(" AND t1.TOPSEG1_060 = ?");
			params.add(ab0460s00.getTopseg1060());
		}
		if (ab0460s00 != null && ab0460s00.getTopseg2060() != null) {
			where.append(" AND t1.TOPSEG2_060 = ?");
			params.add(ab0460s00.getTopseg2060());
		}
		if (ab0460s00 != null && ab0460s00.getTophig1060() != null) {
			where.append(" AND t1.TOPHIG1_060 = ?");
			params.add(ab0460s00.getTophig1060());
		}
		if (ab0460s00 != null && ab0460s00.getTophig2060() != null) {
			where.append(" AND t1.TOPHIG2_060 = ?");
			params.add(ab0460s00.getTophig2060());
		}
		if (ab0460s00 != null && ab0460s00.getToperg1060() != null) {
			where.append(" AND t1.TOPERG1_060 = ?");
			params.add(ab0460s00.getToperg1060());
		}
		if (ab0460s00 != null && ab0460s00.getToperg2060() != null) {
			where.append(" AND t1.TOPERG2_060 = ?");
			params.add(ab0460s00.getToperg2060());
		}
		if (ab0460s00 != null && ab0460s00.getTopvig1060() != null) {
			where.append(" AND t1.TOPVIG1_060 = ?");
			params.add(ab0460s00.getTopvig1060());
		}
		if (ab0460s00 != null && ab0460s00.getTopvig2060() != null) {
			where.append(" AND t1.TOPVIG2_060 = ?");
			params.add(ab0460s00.getTopvig2060());
		}
		if (ab0460s00 != null && ab0460s00.getTiprie1060() != null) {
			where.append(" AND t1.TIPRIE1_060 = ?");
			params.add(ab0460s00.getTiprie1060());
		}
		if (ab0460s00 != null && ab0460s00.getNomrie1060() != null) {
			where.append(" AND t1.NOMRIE1_060 = ?");
			params.add(ab0460s00.getNomrie1060());
		}
		if (ab0460s00 != null && ab0460s00.getTiprie2060() != null) {
			where.append(" AND t1.TIPRIE2_060 = ?");
			params.add(ab0460s00.getTiprie2060());
		}
		if (ab0460s00 != null && ab0460s00.getNomrie2060() != null) {
			where.append(" AND t1.NOMRIE2_060 = ?");
			params.add(ab0460s00.getNomrie2060());
		}
		if (ab0460s00 != null && ab0460s00.getIndaud060() != null) {
			where.append(" AND t1.INDAUD_060 = ?");
			params.add(ab0460s00.getIndaud060());
		}
		if (ab0460s00 != null && ab0460s00.getFecaud060() != null) {
			where.append(" AND t1.FECAUD_060 = ?");
			params.add(ab0460s00.getFecaud060());
		}
		if (ab0460s00 != null && ab0460s00.getEmpaud060() != null) {
			where.append(" AND t1.EMPAUD_060 = ?");
			params.add(ab0460s00.getEmpaud060());
		}
		if (ab0460s00 != null && ab0460s00.getObserv060() != null) {
			where.append(" AND t1.OBSERV_060 = ?");
			params.add(ab0460s00.getObserv060());
		}
		if (ab0460s00 != null && ab0460s00.getCodctr060() != null) {
			where.append(" AND t1.CODCTR_060 = ?");
			params.add(ab0460s00.getCodctr060());
		}
		if (ab0460s00 != null && ab0460s00.getFecalt060() != null) {
			where.append(" AND t1.FECALT_060 = ?");
			params.add(ab0460s00.getFecalt060());
		}
		if (ab0460s00 != null && ab0460s00.getUsualt060() != null) {
			where.append(" AND t1.USUALT_060 = ?");
			params.add(ab0460s00.getUsualt060());
		}
		if (ab0460s00 != null && ab0460s00.getFecmod060() != null) {
			where.append(" AND t1.FECMOD_060 = ?");
			params.add(ab0460s00.getFecmod060());
		}
		if (ab0460s00 != null && ab0460s00.getUsumod060() != null) {
			where.append(" AND t1.USUMOD_060 = ?");
			params.add(ab0460s00.getUsumod060());
		}
		if (ab0460s00 != null && ab0460s00.getDmunemp060() != null) {
			where.append(" AND t1.DMUNEMP_060 = ?");
			params.add(ab0460s00.getDmunemp060());
		}
		if (ab0460s00 != null && ab0460s00.getDescemp060() != null) {
			where.append(" AND t1.DESCEMP_060 = ?");
			params.add(ab0460s00.getDescemp060());
		}
		if (ab0460s00 != null && ab0460s00.getDesccen060() != null) {
			where.append(" AND t1.DESCCEN_060 = ?");
			params.add(ab0460s00.getDesccen060());
		}
		if (ab0460s00 != null && ab0460s00.getPaisemp060() != null) {
			where.append(" AND t1.PAISEMP_060 = ?");
			params.add(ab0460s00.getPaisemp060());
		}
		if (ab0460s00 != null && ab0460s00.getDoccorrecta060() != null) {
			where.append(" AND t1.DOCCORRECTA_060 = ?");
			params.add(ab0460s00.getDoccorrecta060());
		}
		if (ab0460s00 != null && ab0460s00.getCodempaud060() != null) {
			where.append(" AND t1.CODEMPAUD_060 = ?");
			params.add(ab0460s00.getCodempaud060());
		}
		if (ab0460s00 != null && ab0460s00.getCodprev1060() != null) {
			where.append(" AND t1.CODPREV1_060 = ?");
			params.add(ab0460s00.getCodprev1060());
		}
		if (ab0460s00 != null && ab0460s00.getCodprev2060() != null) {
			where.append(" AND t1.CODPREV2_060 = ?");
			params.add(ab0460s00.getCodprev2060());
		}
		if (ab0460s00 != null && ab0460s00.getEstado060() != null) {
			where.append(" AND t1.ESTADO_060 = ?");
			params.add(ab0460s00.getEstado060());
		}
		if (ab0460s00 != null && ab0460s00.getCnaeemp93060() != null) {
			where.append(" AND t1.CNAEEMP93_060 = ?");
			params.add(ab0460s00.getCnaeemp93060());
		}
		if (ab0460s00 != null && ab0460s00.getForpre060() != null) {
			where.append(" AND t1.FORPRE_060 = ?");
			params.add(ab0460s00.getForpre060());
		}
		if (ab0460s00 != null && ab0460s00.getMigrado060() != null) {
			where.append(" AND t1.MIGRADO_060 = ?");
			params.add(ab0460s00.getMigrado060());
		}
		if (ab0460s00 != null && ab0460s00.getFolderId060() != null) {
			where.append(" AND t1.FOLDER_ID_060 = ?");
			params.add(ab0460s00.getFolderId060());
		}
		if (ab0460s00 != null && ab0460s00.getCoddatosnotif060() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_060 = ?");
			params.add(ab0460s00.getCoddatosnotif060());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0460s00 entity.
	 * 
	 * ab0460s00 Ab0460s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(OS2 ab0460s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(OS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0460s00 != null && ab0460s00.getTeros2060() != null) {
			where.append(" AND UPPER(t1.TEROS2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTeros2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTeros2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getAnoos2060() != null) {
			where.append(" AND UPPER(t1.ANOOS2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getAnoos2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getAnoos2060().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNumos2060() != null) {
			where.append(" AND t1.NUMOS2_060 = ?");
			params.add(ab0460s00.getNumos2060());
		}
		if (ab0460s00 != null && ab0460s00.getFecpre060() != null) {
			where.append(" AND t1.FECPRE_060 = ?");
			params.add(ab0460s00.getFecpre060());
		}
		if (ab0460s00 != null && ab0460s00.getFecier060() != null) {
			where.append(" AND t1.FECIER_060 = ?");
			params.add(ab0460s00.getFecier060());
		}
		if (ab0460s00 != null && ab0460s00.getTerape060() != null) {
			where.append(" AND UPPER(t1.TERAPE_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTerape060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTerape060().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getAnoape060() != null) {
			where.append(" AND UPPER(t1.ANOAPE_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getAnoape060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getAnoape060().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNumape060() != null) {
			where.append(" AND t1.NUMAPE_060 = ?");
			params.add(ab0460s00.getNumape060());
		}
		if (ab0460s00 != null && ab0460s00.getTipdoc060() != null) {
			where.append(" AND UPPER(t1.TIPDOC_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTipdoc060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTipdoc060().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNumdoc060() != null) {
			where.append(" AND UPPER(t1.NUMDOC_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNumdoc060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNumdoc060().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNomemp060() != null) {
			where.append(" AND UPPER(t1.NOMEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNomemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNomemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getPrvemp060() != null) {
			where.append(" AND UPPER(t1.PRVEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getPrvemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getPrvemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getMunemp060() != null) {
			where.append(" AND UPPER(t1.MUNEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getMunemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getMunemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDiremp060() != null) {
			where.append(" AND UPPER(t1.DIREMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDiremp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDiremp060().toUpperCase() + "%");
			}
			where.append(" AND t1.DIREMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCpoemp060() != null) {
			where.append(" AND UPPER(t1.CPOEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCpoemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getCpoemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTlfemp060() != null) {
			where.append(" AND UPPER(t1.TLFEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTlfemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTlfemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getFaxemp060() != null) {
			where.append(" AND UPPER(t1.FAXEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getFaxemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getFaxemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getEmaemp060() != null) {
			where.append(" AND UPPER(t1.EMAEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getEmaemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getEmaemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getHttpemp060() != null) {
			where.append(" AND UPPER(t1.HTTPEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getHttpemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getHttpemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCnaeemp060() != null) {
			where.append(" AND UPPER(t1.CNAEEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCnaeemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getCnaeemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAEEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getIndanx060() != null) {
			where.append(" AND UPPER(t1.INDANX_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getIndanx060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getIndanx060().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getApdoanx060() != null) {
			where.append(" AND UPPER(t1.APDOANX_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getApdoanx060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getApdoanx060().toUpperCase() + "%");
			}
			where.append(" AND t1.APDOANX_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getPrvctr060() != null) {
			where.append(" AND UPPER(t1.PRVCTR_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getPrvctr060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getPrvctr060().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVCTR_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getMunctr060() != null) {
			where.append(" AND UPPER(t1.MUNCTR_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getMunctr060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getMunctr060().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNCTR_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getLocctr060() != null) {
			where.append(" AND UPPER(t1.LOCCTR_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getLocctr060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getLocctr060().toUpperCase() + "%");
			}
			where.append(" AND t1.LOCCTR_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDirctr060() != null) {
			where.append(" AND UPPER(t1.DIRCTR_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDirctr060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDirctr060().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRCTR_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCpoctr060() != null) {
			where.append(" AND UPPER(t1.CPOCTR_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCpoctr060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getCpoctr060().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOCTR_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTrbtot060() != null) {
			where.append(" AND t1.TRBTOT_060 = ?");
			params.add(ab0460s00.getTrbtot060());
		}
		if (ab0460s00 != null && ab0460s00.getTipmpr1060() != null) {
			where.append(" AND UPPER(t1.TIPMPR1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTipmpr1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTipmpr1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPMPR1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNommpr1060() != null) {
			where.append(" AND UPPER(t1.NOMMPR1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNommpr1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNommpr1060().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMMPR1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTipmpr2060() != null) {
			where.append(" AND UPPER(t1.TIPMPR2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTipmpr2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTipmpr2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPMPR2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNommpr2060() != null) {
			where.append(" AND UPPER(t1.NOMMPR2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNommpr2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNommpr2060().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMMPR2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTopseg1060() != null) {
			where.append(" AND UPPER(t1.TOPSEG1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTopseg1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTopseg1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPSEG1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTopseg2060() != null) {
			where.append(" AND UPPER(t1.TOPSEG2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTopseg2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTopseg2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPSEG2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTophig1060() != null) {
			where.append(" AND UPPER(t1.TOPHIG1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTophig1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTophig1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPHIG1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTophig2060() != null) {
			where.append(" AND UPPER(t1.TOPHIG2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTophig2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTophig2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPHIG2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getToperg1060() != null) {
			where.append(" AND UPPER(t1.TOPERG1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getToperg1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getToperg1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPERG1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getToperg2060() != null) {
			where.append(" AND UPPER(t1.TOPERG2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getToperg2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getToperg2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPERG2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTopvig1060() != null) {
			where.append(" AND UPPER(t1.TOPVIG1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTopvig1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTopvig1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPVIG1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTopvig2060() != null) {
			where.append(" AND UPPER(t1.TOPVIG2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTopvig2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTopvig2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TOPVIG2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTiprie1060() != null) {
			where.append(" AND UPPER(t1.TIPRIE1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTiprie1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTiprie1060().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPRIE1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNomrie1060() != null) {
			where.append(" AND UPPER(t1.NOMRIE1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNomrie1060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNomrie1060().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRIE1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getTiprie2060() != null) {
			where.append(" AND UPPER(t1.TIPRIE2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getTiprie2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getTiprie2060().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPRIE2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getNomrie2060() != null) {
			where.append(" AND UPPER(t1.NOMRIE2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getNomrie2060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getNomrie2060().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRIE2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getIndaud060() != null) {
			where.append(" AND UPPER(t1.INDAUD_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getIndaud060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getIndaud060().toUpperCase() + "%");
			}
			where.append(" AND t1.INDAUD_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getFecaud060() != null) {
			where.append(" AND t1.FECAUD_060 = ?");
			params.add(ab0460s00.getFecaud060());
		}
		if (ab0460s00 != null && ab0460s00.getEmpaud060() != null) {
			where.append(" AND UPPER(t1.EMPAUD_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getEmpaud060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getEmpaud060().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPAUD_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getObserv060() != null) {
			where.append(" AND UPPER(t1.OBSERV_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getObserv060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getObserv060().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCodctr060() != null) {
			where.append(" AND t1.CODCTR_060 = ?");
			params.add(ab0460s00.getCodctr060());
		}
		if (ab0460s00 != null && ab0460s00.getFecalt060() != null) {
			where.append(" AND t1.FECALT_060 = ?");
			params.add(ab0460s00.getFecalt060());
		}
		if (ab0460s00 != null && ab0460s00.getUsualt060() != null) {
			where.append(" AND UPPER(t1.USUALT_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getUsualt060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getUsualt060().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getFecmod060() != null) {
			where.append(" AND t1.FECMOD_060 = ?");
			params.add(ab0460s00.getFecmod060());
		}
		if (ab0460s00 != null && ab0460s00.getUsumod060() != null) {
			where.append(" AND UPPER(t1.USUMOD_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getUsumod060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getUsumod060().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDmunemp060() != null) {
			where.append(" AND UPPER(t1.DMUNEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDmunemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDmunemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDescemp060() != null) {
			where.append(" AND UPPER(t1.DESCEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDescemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDescemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDesccen060() != null) {
			where.append(" AND UPPER(t1.DESCCEN_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDesccen060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDesccen060().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCCEN_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getPaisemp060() != null) {
			where.append(" AND UPPER(t1.PAISEMP_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getPaisemp060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getPaisemp060().toUpperCase() + "%");
			}
			where.append(" AND t1.PAISEMP_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getDoccorrecta060() != null) {
			where.append(" AND UPPER(t1.DOCCORRECTA_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getDoccorrecta060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getDoccorrecta060().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DOCCORRECTA_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCodempaud060() != null) {
			where.append(" AND UPPER(t1.CODEMPAUD_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCodempaud060().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0460s00.getCodempaud060().toUpperCase() + "%");
			}
			where.append(" AND t1.CODEMPAUD_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCodprev1060() != null) {
			where.append(" AND UPPER(t1.CODPREV1_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCodprev1060().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0460s00.getCodprev1060().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPREV1_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCodprev2060() != null) {
			where.append(" AND UPPER(t1.CODPREV2_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCodprev2060().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0460s00.getCodprev2060().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPREV2_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getEstado060() != null) {
			where.append(" AND UPPER(t1.ESTADO_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getEstado060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getEstado060().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADO_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCnaeemp93060() != null) {
			where.append(" AND UPPER(t1.CNAEEMP93_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCnaeemp93060().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0460s00.getCnaeemp93060().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAEEMP93_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getForpre060() != null) {
			where.append(" AND UPPER(t1.FORPRE_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getForpre060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getForpre060().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRE_060 IS NOT NULL");
		}

		if (ab0460s00 != null && ab0460s00.getMigrado060() != null) {
			where.append(" AND UPPER(t1.MIGRADO_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getMigrado060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getMigrado060().toUpperCase() + "%");
			}
			where.append(" AND t1.MIGRADO_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getFolderId060() != null) {
			where.append(" AND UPPER(t1.FOLDER_ID_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getFolderId060().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0460s00.getFolderId060().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_ID_060 IS NOT NULL");
		}
		if (ab0460s00 != null && ab0460s00.getCoddatosnotif060() != null) {
			where.append(
					" AND UPPER(t1.COD_DATOS_NOTIF_060) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0460s00.getCoddatosnotif060().toUpperCase() + "%");
			} else {
				params.add("%" + ab0460s00.getCoddatosnotif060().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COD_DATOS_NOTIF_060 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the Ab04b60s00 table.
	 * 
	 * folderId String Ab04b60s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	@Transactional(readOnly = true)
	public OS2 findByFolderId(String folderId) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0460S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOOS2_060 = t2.ANOEXP_077 AND t1.TEROS2_060 = t2.TEREXP_077 AND t1.NUMOS2_060 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<OS2> ab04b60s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, folderId);
		return (OS2) DataAccessUtils.uniqueResult(ab04b60s00List);
	}

	/**
	 * Finds a single row in the Ab04b60s00 table.
	 * 
	 * folderId String Ab04b60s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	@Transactional(readOnly = true)
	public OS2 findByFolderId2(String folderId) {
		StringBuilder query = new StringBuilder(QUERY_SELECT_2);
		query.append(" FROM AB0460S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOOS2_060 = t2.ANOEXP_077 AND t1.TEROS2_060 = t2.TEREXP_077 AND t1.NUMOS2_060 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<OS2> ab04b60s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMapPK, folderId);
		return (OS2) DataAccessUtils.uniqueResult(ab04b60s00List);
	}

	/**
	 * Inserts a single row in the Ab04b60s00 table.
	 * 
	 * os2 the os 2 Ab04b60s00
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 addPresencial(OS2 os2) {
		String query = "INSERT INTO AB0460S00 (ANOOS2_060, TEROS2_060, NUMOS2_060, TIPDOC_060, NUMDOC_060, NOMEMP_060, FORPRE_060, MIGRADO_060,DESEA_REG_060, NUM_REGISTRO_060, FEC_REGISTRO_060) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, os2.getAnoos2060(), os2.getTeros2060(),
				os2.getNumos2060(), os2.getTipdoc060(), os2.getNumdoc060(),
				os2.getNomemp060(), Constantes.TIPO_PRESENTACION_PRESENCIAL,
				Constantes.VALUE_NO, os2.getDeseaRegistrar060(),
				os2.getNumReg060(), os2.getFecReg060());
		return os2;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 updateFilled(OS2 os2) {
		StringBuilder query = new StringBuilder("UPDATE AB0460S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os2 != null) {

			if (os2.getFolderId060() != null) {
				queryFields.append(", FOLDER_ID_060 = ? ");
				params.add(os2.getFolderId060());
			}

			if (os2.getFecpre060() != null) {
				queryFields.append(", FECPRE_060 = ? ");
				params.add(os2.getFecpre060());
			}

			if (os2.getEstado060() != null) {
				queryFields.append(", ESTADO_060 = ? ");
				params.add(os2.getEstado060());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?");

		params.add(os2.getTeros2060());
		params.add(os2.getAnoos2060());
		params.add(os2.getNumos2060());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return os2;
	}

	/**
	 * Finds a single row in the Ab04b60s00 table.
	 * 
	 * os2 OS2 Ab04b60s00
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	@Transactional(readOnly = true)
	public OS2 findDatosRegistro(OS2 os2) {
		StringBuilder query = new StringBuilder(
				OS2DaoImpl.QUERY_SELECT_DATOS_REGISTRO);
		query.append(" FROM AB0460S00 t1 ");
		query.append(
				" WHERE t1.ANOOS2_060 = ? AND t1.TEROS2_060 = ? AND t1.NUMOS2_060 = ? ");

		List<OS2> ab04b60s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMapDatosRegistro, os2.getAnoos2060(), os2.getTeros2060(),
				os2.getNumos2060());
		return (OS2) DataAccessUtils.uniqueResult(ab04b60s00List);
	}

	/**
	 * Updates a single row in the Ab04b60s00 table.
	 * 
	 * ab04b60s00 Ab04b60s00 Ab04b60s00
	 * 
	 * @param ab04b60s00
	 *            the ab 04 b 60 s 00
	 * @return the os2
	 */
	public OS2 modificarDatosRegistro(OS2 ab04b60s00) {
		String query = "UPDATE AB0460S00 SET DESEA_REG_060=?, NUM_REGISTRO_060=?, FEC_REGISTRO_060=?  WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?";
		this.jdbcTemplate.update(query, ab04b60s00.getDeseaRegistrar060(),
				ab04b60s00.getNumReg060(), ab04b60s00.getFecReg060(),
				ab04b60s00.getTeros2060(), ab04b60s00.getAnoos2060(),
				ab04b60s00.getNumos2060());
		return ab04b60s00;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.OS2Dao#updateUsuariosTramitacion(com.ejie.ab04b.model
	 * .OS2)
	 */
	@Override()
	public OS2 updateUsuariosTramitacion(OS2 os2) {
		StringBuilder query = new StringBuilder("UPDATE AB0460S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os2 != null) {

			if (os2.getUsuarioApe060() != null) {
				queryFields.append(", USUARIO_APE_060 = ? ");
				params.add(os2.getUsuarioApe060());
			}

			if (os2.getUsuarioAport060() != null) {
				queryFields.append(", USUARIO_APORT_060 = ? ");
				params.add(os2.getUsuarioAport060());
			}

			if (os2.getUsuarioTram060() != null) {
				queryFields.append(", USUARIO_TRAM_060 = ? ");
				params.add(os2.getUsuarioTram060());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?");

		params.add(os2.getTeros2060());
		params.add(os2.getAnoos2060());
		params.add(os2.getNumos2060());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return os2;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.dao.OS2Dao#updateEstado(com.ejie.ab04b.model.OS2)
	 */
	@Override
	public void updateEstado(OS2 os2) {
		String query = "UPDATE AB0460S00 SET ESTADO_060=? WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=? ";
		this.jdbcTemplate.update(query, os2.getEstado060(), os2.getTeros2060(),
				os2.getAnoos2060(), os2.getNumos2060());

	}

	@Override()
	public void updateBatchSub(OS2 os2) {

		StringBuilder query = new StringBuilder(
				"UPDATE AB0460S00 SET IND_BATCH_SUB_060=0");

		List<Object> params = new ArrayList<Object>();

		query.append(" WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?");

		params.add(os2.getTeros2060());
		params.add(os2.getAnoos2060());
		params.add(os2.getNumos2060());

		this.jdbcTemplate.update(query.toString(), params.toArray());
	}

	@Override
	public void updateFecSub(OS2 os2) {
		StringBuilder query = new StringBuilder("UPDATE AB0460S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os2 != null) {

			if (os2.getFecsub060() != null) {
				queryFields.append(", FECSUB_060 = ? ");
				params.add(os2.getFecsub060());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TEROS2_060=? AND ANOOS2_060=? AND NUMOS2_060=?");

		params.add(os2.getTeros2060());
		params.add(os2.getAnoos2060());
		params.add(os2.getNumos2060());

		this.jdbcTemplate.update(query.toString(), params.toArray());

	}
}
